/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import java.nio.Buffer;

final class ObjectBuffer {
    public static final int IN = 1;
    public static final int OUT = 2;
    public static final int ZERO_TERMINATE = 4;
    public static final int PINNED = 8;
    public static final int CLEAR = 16;
    static final int INDEX_SHIFT = 16;
    static final int INDEX_MASK = 0xFF0000;
    static final int TYPE_SHIFT = 24;
    static final int TYPE_MASK = -16777216;
    static final int PRIM_MASK = 0xF000000;
    static final int FLAGS_SHIFT = 0;
    static final int FLAGS_MASK = 255;
    static final int ARRAY = 0x10000000;
    static final int BUFFER = 0x20000000;
    static final int JNI = 0x40000000;
    static final int BYTE = 0x1000000;
    static final int SHORT = 0x2000000;
    static final int INT = 0x3000000;
    static final int LONG = 0x4000000;
    static final int FLOAT = 0x5000000;
    static final int DOUBLE = 0x6000000;
    public static final int JNIENV = 0x1000000;
    public static final int JNIOBJECT = 0x2000000;
    private Object[] objects = new Object[1];
    private int[] info = new int[this.objects.length * 3];
    private int infoIndex = 0;
    private int objectIndex = 0;

    ObjectBuffer() {
    }

    final int objectCount() {
        return this.objectIndex;
    }

    final int[] info() {
        return this.info;
    }

    final Object[] objects() {
        return this.objects;
    }

    private final void ensureSpace() {
        if (this.objects.length <= this.objectIndex + 1) {
            Object[] objectArray = new Object[this.objects.length << 1];
            System.arraycopy(this.objects, 0, objectArray, 0, this.objectIndex);
            this.objects = objectArray;
            int[] nArray = new int[this.objects.length * 3];
            System.arraycopy(this.info, 0, nArray, 0, this.objectIndex * 3);
            this.info = nArray;
        }
    }

    private static final int makeArrayFlags(int n, int n2, int n3) {
        return n & 0xFF | n3 << 16 & 0xFF0000 | n2;
    }

    private static final int makeBufferFlags(int n) {
        return n << 16 & 0xFF0000 | 0x20000000;
    }

    private static final int makeJNIFlags(int n, int n2) {
        return n << 16 & 0xFF0000 | 0x40000000 | n2;
    }

    public void putArray(int n, byte[] byArray, int n2, int n3, int n4) {
        this.putObject(byArray, n2, n3, ObjectBuffer.makeArrayFlags(n4, 0x11000000, n));
    }

    public void putArray(int n, short[] sArray, int n2, int n3, int n4) {
        this.putObject(sArray, n2, n3, ObjectBuffer.makeArrayFlags(n4, 0x12000000, n));
    }

    public void putArray(int n, int[] nArray, int n2, int n3, int n4) {
        this.putObject(nArray, n2, n3, ObjectBuffer.makeArrayFlags(n4, 0x13000000, n));
    }

    public void putArray(int n, long[] lArray, int n2, int n3, int n4) {
        this.putObject(lArray, n2, n3, ObjectBuffer.makeArrayFlags(n4, 0x14000000, n));
    }

    public void putArray(int n, float[] fArray, int n2, int n3, int n4) {
        this.putObject(fArray, n2, n3, ObjectBuffer.makeArrayFlags(n4, 0x15000000, n));
    }

    public void putArray(int n, double[] dArray, int n2, int n3, int n4) {
        this.putObject(dArray, n2, n3, ObjectBuffer.makeArrayFlags(n4, 0x16000000, n));
    }

    public void putDirectBuffer(int n, Buffer buffer, int n2, int n3) {
        this.putObject(buffer, n2, n3, ObjectBuffer.makeBufferFlags(n));
    }

    public void putJNI(int n, int n2) {
        this.putObject(null, 0, 0, ObjectBuffer.makeJNIFlags(n, n2));
    }

    private void putObject(Object object, int n, int n2, int n3) {
        this.ensureSpace();
        this.objects[this.objectIndex++] = object;
        this.info[this.infoIndex++] = n3;
        this.info[this.infoIndex++] = n;
        this.info[this.infoIndex++] = n2;
    }
}

